/*\file Orth.c
 *\brief: orthogonalize searching directions for inverse control methods.
 */

#include "./Orth.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Vec gradj=NULL;
	Vec oldgradj=NULL;

	/* output datasets: */
	Vec newgradj=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&OrthUsage);

	/*Input datasets: */
	FetchData((void**)&gradj,NULL,NULL,GRADJ,"Vector",NULL);
	FetchData((void**)&oldgradj,NULL,NULL,OLDGRADJ,"Vector",NULL);

	/*!Reduce load from g to f size: */
	Orthx(&newgradj, gradj,oldgradj);

	/*write output datasets: */
	WriteData(NEWGRADJ,newgradj,0,0,"Vector",NULL);

	/*Free ressources: */
	VecFree(&gradj);
	VecFree(&oldgradj);
	VecFree(&newgradj);

	/*end module: */
	MODULEEND();
}

void OrthUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [newgradj] = %s(gradj,oldgradj);\n",__FUNCT__);
	_printf_("\n");
}
