/*\file ModelProcessor.h
 * \brief: ModelProcessor module include
 */

#ifndef _MEXMODELPROCESSOR_H_
#define _MEXMODELPROCESSOR_H_

/* local prototypes: */
void ModelProcessorUsage(void);

#include "../../c/issm.h"

#undef __FUNCT__ 
#define __FUNCT__  "ModelProcessor"

#undef CLEANUP
#define CLEANUP ModelProcessorLocalCleanup();

#undef ALL
#define ALL 0

/* serial input macros: */
#define MODEL (mxArray*)prhs[0]

/* serial output macros: */
#define ELEMENTS (mxArray**)&plhs[0]
#define NODES (mxArray**)&plhs[1]
#define CONSTRAINTS (mxArray**)&plhs[2]
#define LOADS (mxArray**)&plhs[3]
#define MATERIALS (mxArray**)&plhs[4]
#define PARAMETERS (mxArray**)&plhs[5]
		
/* serial arg counts: */
#undef NLHS
#define NLHS  6
#undef NRHS
#define NRHS  1

#endif  /* _MEXMODELPROCESSOR_H */

