function [server_codepath server_executionpath]=ProcessParallelParametersFromCieloRc(server_name,cielo_rc_location)
%PROCESSPARALLELPARAMETERSFROMCIELORC - process parallel parameters from cielo
%
%   This function reads through the cielo_rc_location for server settings (name, ip, port and 
%   tunneling) used to run parallel solution sequences
%
%   Usage:
%      [server_codepath server_executionpath]=ProcessParallelParametersFromCieloRc(server_name,cielo_rc_location)

lines_per_server=5;
%open cielo.rc file
fid=fopen(cielo_rc_location);
if fid==-1,
	error('Could not find cielo.rc file in delivery directory');
end

found=0;

%Read first line and check it starts with begin. 
line=fgetl(fid);
if ~strcmp(line,'begin'),
	error('cielo.rc file in delivery directory should always start with the begin statement');
end

%Read until we find the end statement. 
while 1
	line=fgetl(fid);
	
	%Check for 'end' statement
	if strcmp(line,'end'),
		break;
	end 
	%Check for end of file
	if ~ischar(line),
		error('cielo.rc file in delivery directory should end with an end statement');
	end
	%Ignore empty lines
	if length(line)==0,
		continue;
	end
	%Ignore comments
	if strcmp(line(1),'#'),
		continue
	end

	%Handle server name: 
	if length(line)>11,
		if strcmp(line(1:11),'server_name'),
			%ok, the next 4 lines deal with one server settings.
			%check if this is the server we are looking for.
			splittedstring=strsplit(line,'=');
			this_server_name=splittedstring{2};
			if strcmp(this_server_name,server_name),

				%Skip next 3 lines
				line=fgetl(fid);
				line=fgetl(fid);
				line=fgetl(fid);

				%Get next line for server code path
				line=fgetl(fid);
				splittedstring=strsplit(line,'=');
				descriptor=splittedstring{1};
				value=splittedstring{2};
				if ~strcmp(descriptor,'server_codepath'),
					error('server settings in cielo.rc don''t follow the correct syntax');
				end
				server_codepath=value;
				found=1;
				
				
				%Get next line for server execution path
				line=fgetl(fid);
				splittedstring=strsplit(line,'=');
				descriptor=splittedstring{1};
				value=splittedstring{2};
				if ~strcmp(descriptor,'server_executionpath'),
					error('server settings in cielo.rc don''t follow the correct syntax');
				end
				server_executionpath=value;

			else
				%Wrong server name, skip next lines_per_server lines and continue;
				for i=1:lines_per_server,
					line=fgetl(fid);
				end
				continue;
			end
		end
	end
end

fclose(fid);

if found==0,
	error(['ProcessParallelParametersFromCieloRc error message: could not find setting for cluster ' server_name 'in cielo.rc file']);
end

end %close of function
