function  [x,y]=mapll(alat,alon,hem);
%MAPLL - convert latitude and longitude into x and y
%
%   latitude and longitude are in degrees.
%   Hemisphere must be 1 for north and 0 for south
%
%   Usage:
%      [x,y]=mapll(latitude,longitude,hemisphere)
%
%   See also MAPXY, LL2XY

re=6378137.0; 
e2= 0.00669437999015;

e=sqrt(e2);

%Standard parallel - latitude with no distortion = -71.
slat=71;
sn=-1.0;
xlam=0;

if hem==1,
   xlam=45;
	sn=1;
	slat=70;
end

alat=sn*alat;
alon=sn*alon;
alat=alat/180*pi;
alon=alon/180*pi;

rlat=alat;
slat=slat/180*pi;
xlam=xlam/180*pi;

t1=tan(pi/4.-rlat/2.)./((1.0-e*sin(rlat))./...
(1.0+e*sin(rlat))).^(e/2.);

t2=tan(pi/4.-slat/2.)./((1.0-e*sin(slat))./...
(1.0+e*sin(slat))).^(e/2.);

cm=cos(slat)./sqrt(1.0-e2*(sin(slat).^2));
rho=re*cm.*t1./t2;
x= rho*sn.*sin((alon+xlam));
y=-rho*sn.*cos((alon+xlam));
