function [A,numprofiles,numpoints,closed]=mergeprofiles(A,numprofiles,numpoints,closed,prevplot,root);
%MERGEPROFILES - morge profiles
%
%   this script is used by expmaster as an elementary operation
%   on an ARGUS profile. The user must select the two tips that
%   he/she wants to merge
%
%   Usage:
%      [A,numprofiles,numpoints,closed]=mergeprofiles(A,numprofiles,numpoints,closed,prevplot,root)

	hold on
	loop=1;

	%Take all the tips coordinates
	tips=zeros(2*numprofiles,4);
	for i=1:numprofiles
		%x and y coord, profile number, 1 if beginning, 2 and if end
		tips(2*i-1,:)=[A(i).x(1)   A(i).y(1)   i  1];
		tips(2*i,:) = [A(i).x(end) A(i).y(end) i  2];
	end
	%remove the closed profiles fron the list
	tips([2*find(closed)-1;2*find(closed)],:)=[];

	if size(tips,1)<2
		disp('at least one unclosed profiles are required')
		return
	end

	%plot the tips
	plot(tips(:,1),tips(:,2),'rs','Markersize',10);
	firsttip=1;

	%loop (at least 2 clicks needed)
	while loop
	
		%some checks
		if size(tips,1)<2
			disp('at least one unclosed profiles are required')
			return
		end

		%select a point
		if firsttip
			title('click on the first tip, RETURN to exit','FontSize',14)
		else
			title('click on the second tip, RETURN to exit','FontSize',14)
		end

		[xi,yi] = ginput(1);

		if ~isempty(xi)

			if firsttip
				%find the selected tip
				distance=(xi-tips(:,1)).^2+(yi-tips(:,2)).^2;
				[dmin tip1]=min(distance);
				numprofile1=tips(tip1,3);
				firsttip=0;

				%remove tip1 grom tips list
				newtips=tips;
				newtips(tip1,:)=[];

				%plot selected tip
				plot(tips(tip1,1),tips(tip1,2),'bs','MarkerSize',10);
				plot(A(numprofile1).x,A(numprofile1).y,'-g');

			%second selection
			else
				distance=(xi-newtips(:,1)).^2+(yi-newtips(:,2)).^2;
				[dmin tip2]=min(distance);
				numprofile2=newtips(tip2,3);

				%reverse if necessary
				if numprofile2<numprofile1
					fakeprofile=numprofile2;
					numprofile2=numprofile1;
					numprofile1=fakeprofile;
				end

				if numprofile1==numprofile2
					%close the profile
					A(numprofile1).x(end+1)=A(numprofile1).x(1);
					A(numprofile1).y(end+1)=A(numprofile1).y(1);
					numpoints=numpoints+1;
					closed(numprofile1)=1;

				else

					if tips(tip1,4)==1 & newtips(tip2,4)==1,
						A(numprofile1).x=[flipud(A(numprofile2).x); A(numprofile1).x];
						A(numprofile1).y=[flipud(A(numprofile2).y); A(numprofile1).y];
						numprofiles=numprofiles-1;
						closed(numprofile1)=1;

					elseif tips(tip1,4)==1 & newtips(tip2,4)==2,
						A(numprofile1).x=[A(numprofile2).x; A(numprofile1).x];
						A(numprofile1).y=[A(numprofile2).y; A(numprofile1).y];
						numprofiles=numprofiles-1;
						closed(numprofile1)=1;

					elseif tips(tip1,4)==2 & newtips(tip2,4)==1,
						A(numprofile1).x=[A(numprofile1).x; A(numprofile2).x];
						A(numprofile1).y=[A(numprofile1).y; A(numprofile2).y];
						numprofiles=numprofiles-1;
						closed(numprofile1)=1;

					elseif tips(tip1,4)==2 & newtips(tip2,4)==2,
						A(numprofile1).x=[A(numprofile1).x; flipud(A(numprofile2).x)];
						A(numprofile1).y=[A(numprofile1).y; flipud(A(numprofile2).y)];
						numprofiles=numprofiles-1;
						closed(numprofile1)=1;
					end

					%delete profile2
					A(numprofile2)=[];
					closed(numprofile2)=[];

				end

				%update tips
				tips=newtips;
				tips(tip2,:)=[];
				tips(find(tips(:,3)==numprofile2),3)=numprofile1;

				%plot new profile
				undoplots(prevplot);
				for i=1:numprofiles
					plot(A(i).x,A(i).y,'-r','MarkerSize',10);
				end
				plot(tips(:,1),tips(:,2),'rs','Markersize',10);

				%back to beginning
				firsttip=1;
			end
		else
			%RETRUN-> quit
			loop=0;
		end
	end
end
