function [A,numprofiles,numpoints,closed]=closeprofile(A,numprofiles,numpoints,closed,prevplot,root);
%CLOSEPROFILE - close one or several profile
%
%   this script is used by expmaster as an elementary operation
%   on an ARGUS profile
%
%   Usage:
%      [A,numprofiles,numpoints,closed]=closeprofile(A,numprofiles,numpoints,closed,prevplot,root)

	%some checks
	if numprofiles==0
		disp('no profile to be closed')
		return
	end
		   
	title('click on the profiles to be closed, RETURN to exit','FontSize',14)
	hold on

	loop=1;
	selection=[];

	while loop

		[xi,yi] = ginput(1);
					  
		if ~isempty(xi)

			%get closest profile
			[profsel indsel]=closestpoint(A,numprofiles,xi,yi);

			if ismember(profsel,selection)
				%profile was in selection, close it
				selection(find(selection==profsel))=[];
				%back to red
				plot(A(profsel).x,A(profsel).y,'-r','MarkerSize',10);
			else
				%add the profile to the list to be closed
				selection(end+1)=profsel;
				%in blue
				plot(A(profsel).x,A(profsel).y,'-b','MarkerSize',10);
			end
		else
			%close the profiles
			for i=1:length(selection),
				if (A(selection(i)).x(end)~=A(selection(i)).x(1) | A(selection(i)).y(end)~=A(selection(i)).y(1))
					A(selection(i)).x(end+1)=A(selection(i)).x(1);
					A(selection(i)).y(end+1)=A(selection(i)).y(1);
					numpoints=numpoints+1;
					closed(selection(i))=1;
				else
					disp('one profile is already closed')
				end
			end
			loop=0;
		end
	end
end
