function expboxgen(x0,y0,nx,ny,parameter_filename,box_filename)
%EXPBOXGEN -  creates a domain outline box for a tiff image
%
%   This function creates a domain outline box for a .tif image for the 
%   mosaic tiff. 
%   x0,y0 and x1,y1 are the cropping coordinates (upper left and lower right 
%   corners in the larger tiff image).
%   paramter_filename is the parameter file name for the mosaic tiff image.
%   box_filename is self explanatory.
%
%   Usage:
%      expboxgen(x0,y0,nx,ny,parameter_filename,box_filename)
%
%   See also EXPMASTER, EXPDOC

%initialize
nrows=-1;
ncols=-1;
X0=-1;
Y0=-1;
posting=-1;

%first recover necessary information from the paramter_filename.
fid=fopen(parameter_filename,'r');
count=1;
while(1),
tline=fgetl(fid);
if ~isstr(tline), break; end;

ind=findstr('ant125m',tline);
if ~isempty(ind),
a=strsplit(tline,' ');
a=a(2); a=char(a); a=a(1:length(a)-1);
posting=str2num(a);
end


ind=findstr('no. of rows   :',tline);
if ~isempty(ind),
a=strsplit(tline,' ');
nrows=str2num(char(a(length(a))));
end

ind=findstr('no. of columns:',tline);
if ~isempty(ind),
a=strsplit(tline,' ');
ncols=str2num(char(a(length(a))));
end

ind=findstr('Upper Left X:',tline);
if ~isempty(ind),
a=strsplit(tline,' ');
X0=str2num(char(a(length(a))));
end

ind=findstr('Upper Left Y:',tline);
if ~isempty(ind),
a=strsplit(tline,' ');
Y0=str2num(char(a(length(a))));
end


end %while(1),


fclose(fid);

if (X0==-1 | Y0==-1 | nrows==-1  | ncols==-1 | posting==-1),
disp(' ');
disp(['Could not recover all parameters from ' parameter_filename]);
disp('Here are the paramters recovered thus far: ');
disp(['no. of rows: ' num2str(nrows)]);
disp(['no. of columns: ' num2str(ncols)]);
disp(['Upper Left X: ' num2str(X0)]);
disp(['Upper Left Y: ' num2str(Y0)]);
disp(['Posting: ' num2str(posting)]);
end

disp(' ');
disp(['Recovered the following parameters from ' parameter_filename]);
disp(['no. of rows: ' num2str(nrows)]);
disp(['no. of columns: ' num2str(ncols)]);
disp(['Upper Left X: ' num2str(X0)]);
disp(['Upper Left Y: ' num2str(Y0)]);
disp(['Posting: ' num2str(posting)]);

%Create X,Y, arrays of coordinates:
X(1)=X0+x0*posting
Y(1)=Y0-y0*posting
X(2)=X(1);
Y(2)=Y(1)-ny*posting;
X(3)=X(1)+nx*posting;
Y(3)=Y(2);
Y(4)=Y(1);
X(4)=X(3);
plot(X,Y,'r*');

%Create box exp file using X and Y. Loop it.
expgen(box_filename,X,Y,1);
