function [tau_xx, tau_yy,tau_xy]=stress(u,v)
%STRESS - compute the stress components
%
%   this routine calculates the components of the stress tensor in 2D
%
%   Usage:
%      [tau_xx, tau_yy,tau_xy]=stress(u,v)

nu_bar=viscosity(u,v);
[ux,uy,vx,vy]=shear(u,v);
tau_xx=2*nu_bar.*ux;
tau_yy=2*nu_bar.*vy;
tau_xy=nu_bar.*(uy+vx);
