function [alpha,beta,gamma,area]=shape(index,x,y,nel,nods)
%SHAPE - compute nodal functions coefficients and triangle area
%
%   this routine calculates the coefficients of all the nodal functions and the area of each
%   element with:
%   o N(x,y)=alpha*x+beta*y+gama
%
%   Usage:
%      [alpha,beta,gamma,area]=shape(index,x,y,nel,nods)

alpha=zeros(nel,3); beta=zeros(nel,3); 
gamma=zeros(nel,3); area=zeros(nel,1);
for n=1:nel
	X=inv([x(index(n,:)) y(index(n,:)) ones(3,1)]);
	alpha(n,:)=X(1,:);
	beta(n,:)=X(2,:);
	gamma(n,:)=X(3,:);
	area(n)=1/2 * det([1 1 1;x(index(n,:))';y(index(n,:))']);
end
clear X;
area=abs(area);
