%CREATE_EL2NOD_MATRICES - build some useful matrices
%
%   this script builds two matrices: el2nod and el2nodRhs. The first one is used to
%   evaluate the value of a parameter over a grid when it is defined over the elements.
%   The second matrix is used for the same purpose but with derivated parameters 
%   (constant over the elements).

row_location=zeros(nel*3*3,1);
col_location=zeros(nel*3*3,1);
value=zeros(nel*3*3,1);
right_hand_side=zeros(nel*3*3,1);
col_elements=zeros(nel*3*3,1);
epsilon=1;
count=-nel+1;
for j=1:3
	for i=1:3
			count=count+nel;
			row_location(count:count+nel-1)=index(:,i);
			col_location(count:count+nel-1)=index(:,j);
			col_elements(count:count+nel-1)=[1:nel]';
			value(count:count+nel-1)=area.*(alpha(:,i).*alpha(:,j)*epsilon ...
			+ beta(:,i).*beta(:,j)*epsilon ... 
			+( (i==j)/6 + (i~=j)/12 ) );
			right_hand_side(count:count+nel-1)=area/9;
	end
end
el2nod=sparse(row_location,col_location,value,nods,nods);
el2nodRhs=sparse(row_location,col_elements,right_hand_side,nods,nel);
