function viscousheating=ViscousHeatingCompute(m,inputs,type);
%VISCOUSHEATINGCOMPUTE - compute viscous heating
%
%   return a vector of size (numberofelements,1), holding the viscous heating for 
%   every element
%
%   Usage:
%      viscousheating=ViscousHeatingCompute(m,inputs,type)

%global variables
global cluster gridset

%recover fem model fields
elements=m.elements;
grids=m.grids;
materials=m.materials;
loads=m.loads;
gridset=m.gridset;

%figure out active elements that will take part in the stiffness and load generation
[n1,n2]=GetNumberOfActiveElements(elements);

%initialize vector
viscousheating=zeros((n2-n1)+1,1);

%Go through all elements and call the vicous heating routine.
for n=n1:n2,
		
	if ~isempty(elements(n).element),
		viscousheating(n)=ViscousHeating(elements(n).element,grids,materials,inputs);
	end

end
