function velocity_average_g=HorizontalVelocityDepthAverage(md,velocity_g);
%HORIZONTALVELOCITYDEPTHAVERAGE - compute the depth averaged horizontal velocity
%
%   Usage:
%      velocity_average_g=HorizontalVelocityDepthAverage(md,velocity_g)

global gridset

vx_average2d=DepthAverage(md,velocity_g(1:6:gridset.gsize));
vy_average2d=DepthAverage(md,velocity_g(2:6:gridset.gsize));

%project onto layer 1 of 3d mesh
vx_average=project3d(md,vx_average2d,'node',1);
vy_average=project3d(md,vy_average2d,'node',1);

%output on g-set
velocity_average_g=zeros(gridset.gsize,1);velocity_average_g(1:6:gridset.gsize)=vx_average;velocity_average_g(2:6:gridset.gsize)=vy_average;


