%
%  plot a box plot of the response functions.
%
%  []=plot_boxplot(rfunc)
%
function []=plot_boxplot(rfunc)

if ~nargin
    help plot_boxplot
    return
end

%%  assemble the data into a matrix

desc=cell (1,length(rfunc));
for i=1:length(rfunc)
    ldata(i)=length(rfunc(i).sample);
end
data=zeros(max(ldata),length(rfunc));

for i=1:length(rfunc)
    desc(i)=cellstr(rfunc(i).descriptor);
    data(1:ldata(i),i)=rfunc(i).sample;
end

%%  draw the plot

%  draw box plot

boxplot(data,'labels',desc,'notch','on')
ax1=gca;

%  add the annotation

title('Box Plot of Design Variables and/or Response Functions')
xlabel('Design Variable or Response Function')
ylabel('Value')

end
