%
%  define the data to write the dakota .in file
%
%  []=dakota_in_data(md,filei,package)
%
function []=dakota_in_data(md,filei,package)

if ~nargin
    help dakota_in_data
    return
end

%%  variables

fnames=fieldnames(md.variables);
for i=1:length(fnames)
    fhandle=str2func([class(md.variables.(fnames{i})) '.empty']);
    dvar.(fnames{i})=fhandle();
    for j=1:length(md.variables.(fnames{i}))
        %call setupdesign
        dvar.(fnames{i})=QmuSetupDesign(md,dvar.(fnames{i}),md.variables.(fnames{i})(j)); 
    end
end

%%  responses

fnames=fieldnames(md.responses);
for i=1:length(fnames)
    fhandle=str2func([class(md.responses.(fnames{i})) '.empty']);
    dresp.(fnames{i})=fhandle();
    for j=1:length(md.responses.(fnames{i}))
        dresp.(fnames{i})(j)=md.responses.(fnames{i})(j);
    end
end

%%  run parameters

params=dakota_in_params(struct());

params.evaluation_concurrency=md.evaluation_concurrency;
params.npart=md.npart;
disp(md.method);

if     strncmpi(md.method,'nond_l',6),
	params.method               ='nond_local_reliability';
	params.interval_type        =md.interval_type;
	params.fd_gradient_step_size=md.fd_gradient_step_size;
elseif strncmpi(md.method,'nond_s',6),
	params.method               ='nond_sampling';
	params.seed                 =md.seed;
	params.samples              =md.samples;
	params.sample_type          =md.sample_type;
elseif strncmpi(md.method,'conmin_f',8),
	params.method               ='conmin_frcg';
elseif strncmpi(md.method,'conmin_m',8),
	params.method               ='conmin_mfd';
else
	error('dakota_in_data: error message, method not supported yet!');
end

if     strcmpi(md.analysis_driver,'matlab')
    params.analysis_driver='matlab';
    if ~isempty(md.analysis_components)
        params.analysis_components=md.analysis_components;
    else
        params.analysis_components=filei;
    end
elseif ~isempty(md.analysis_driver)
    params.analysis_driver=md.analysis_driver;
else
    md.analysis_driver=params.analysis_driver;
end

%Write in file
dakota_in_write(params.method,dvar,dresp,filei,params);

%Write m file
dakota_m_write(md,params.method,dvar,dresp,filei,params,package);

end
