function solution=controlfinalsol(c,m,p_g);

%From parameters, build inputs for icediagnostic_core, using the final parameters
eval(['inputs.' m.parameters.control_type '=p_g;']);

u_g=diagnostic_core_nonlinear(m,inputs);

%Build partitioning vectors to recover solution
indx=m.part(1:2:end);
indy=m.part(2:2:end);

%Recover velocity, and parameters, in the correct partitioning.
vx=u_g(indx);
vy=u_g(indy);
vel=sqrt(vx.^2+vy.^2);

parameter=p_g(indx);

%Recover misfit at each iteration of the control method 
J=zeros(length(c),1);
for i=1:length(c),
	J(i)=c(i).J;
end

%Store in solution
solution.vx=vx;
solution.vy=vy;
solution.vel=vel;
solution.J=J;
solution.parameter=parameter;
