function [rh_g]=cieloprognostic_func(m,params,inputs)
%INPUT function [rh_g]=cieloprognostic_func(m,params,inputs)

	analysis='prognostic';

	%Check arguments
	if nargin==0,
		cieloprognostic_func_usage;
		error(' ');
	end
	
	options_string='';

	%recover flag_y_s from m.y_s
	if m.y_s.header.M==0,
		flag_y_s= 0;
	else
		flag_y_s= 1;
	end
	
	%	stiffness and load generation only:
	kflag=1; pflag=1; ktflag=0;
	
	%	disp('stiffness, damping, and mass matrix generation...');
		[rK_gg , rp_g , rdK_gg]=Emg(m.bgpdt,m.bgpdtb, m.est,m.ept,m.mpt,m.geom3,kflag,params.sparsity,params.penalty,pflag,ktflag, {},{},inputs,analysis);
				
	%	Reduce tangent matrix from g size to f size
			
		[rK_ff, rK_fs] = Reducematrixfromgtof( rK_gg, m.G_mn, flag_y_s ); 

		[rK_gg,rdK_gg]=IMdb('drop rK_gg rdK_gg');
		
	%	Reduce load from g size to f size

		[rp_f] = Reducerightside( rp_g, m.G_mn, rK_fs, m.y_s, flag_y_s );

		[rp_g rK_fs]=IMdb('drop rp_g rK_fs');
			

	%   Solve	
		if(uset.fsize>0)
			if strcmp(client_server_mode,'yes'),
				%options_string='-ksp_type gmres or cg -pc_type bjacobi or jacobi -ksp_view -pc_factor_zeropivot 1e-30 -ksp_singmonitor ';
				%options_string='-ksp_type cg  -ksp_singmonitor -pc_type bjacobi  -ksp_rtol 1e-11 -ksp_singmonitor ';           
				options_string='-mat_type aijmumps -mat_mumps_sym 1 -ksp_type preonly -pc_type lu -mat_mumps_icntl_14 40';
			end
			rh_f=Solver(rK_ff,rp_f,{},options_string);
		else
			disp('All dof are constrained, f_set is empty...');
		end
		[rK_ff rp_f]=IMdb('drop rK_ff rp_f');

		
	%   Merge back to g set
		rh_g= Mergesolvec( rh_f, m.G_mn, m.y_s ); 
		[rh_f]=IMdb('drop rh_f ');

function cieloprognostic_func_usage(),

disp('function [rh_g]=cieloprognostic_func(m,params,inputs)');
disp('%INPUT function [rh_g]=cieloprognostic_func(m,params,inputs)');

