function new_u_g=SwitchPartitioning(u_g,destination,part,tpart,doflist);
%INPUT function new_u_g=SwitchPartitioning(u_g,destination,part,tpart,doflist);

gsize=length(u_g);
if strcmpi(destination,'workspace'),
	%g-size vector u_g is ordered according to a parallel partition. REorder it 
	%so that u_g correspondgs to the workspace partition (ie: the initial grid 
	%partition)
	new_u_g=zeros(gsize,1);
	
	%go through list of degrees of freedom that need repartitioning
	for i=1:length(doflist),
		dof=doflist(i);
		ind=dof:6:gsize; ind=ind(tpart);
		new_u_g(dof:6:gsize)=u_g(ind);
	end
elseif strcmpi(destination,'cluster'),
	%g size  vector u_g is ordered according to the matlab workspace. We need to 
	%reorder it so that u_g is now ordered in the parallel partition.

	new_u_g=zeros(gsize,1);

	for i=1:length(doflist), 
		dof=doflist(i);
		ind=dof:6:gsize; vector=u_g(ind);
		new_u_g(dof:6:gsize)=vector(part);
	end
else
	error('SwitchPartitioning error message: only types of destination allowed are ''workspace'' or ''cluster''!');
end
