function [G_mn]= normalizeconstraints( R_mg ,uset);
% NORMALIZECONSTRAINTS [G_mn]= normalizeconstraints( pR_mg )
%
% Calculates the G_mn matrix from the Jacobian of the
% multi point and rigid constraints R_mg
%
% G_mn = -inv(R_mm) * R_mn
%
% where R_mg = [ R_mm R_mn ]
%
% m dependent dof 
% n independent dof
% g global dof g = m + n
%
% Input:  pR_mg    	pointer to R_mg matrix on data base
%		            R_mg is the m x g matrix of constraints
%					Use m.R_mg in the calling script
%
% Output: G_mn      m x n normalized matrix of constraints in the workspace
%
% Input from global workspace:
%
%         uset      uset.pv_*  	partitioning vector
%					uset.*size 	size 
%								*=n,m etc.
%
% Called by  sol101 (ms), Normalmodes (ms), sol159 (ms) (all solution sequences)
% Calls  IMdb (mex)
% where ms= m-script, mf= m-function, mex= executable function (c-code)
%
% uset.pv_m and uset.pv_n partitioning indicees are with respect to the g- set
%
% R_mg is the matrix (Jacobian) of constraints from MPCs and rigid elements,
% with m rows and g columns. The m constraint equations are used to eliminate m
% dof out of g dof leaving n dof . The normalized constraint matrix G_mn
% is needed for later elimination, partition and merge operations.
%

% Retrieve R_mg, partition, and calculate G_mn

if(uset.msize>0)

	R_mm = R_mg(:, uset.pv_m);
	R_mn = R_mg(:, uset.pv_n);

	G_mn= - inv(R_mm) * R_mn;

else

	G_mn= [];

end
