function [u_g]= mergesolvec( u_f, G_mn, y_s ,uset);
% MERGESOLVEC [u_g]= mergesolvec ( u_f, G_mn, y_s )
% Merges solution vectors (displacement/temperature) from f size to g size, 
% u_f to u_g,
% the solution vectors can be total in linear or incremental in nonlinear.
%
% g global dof g = m + n
% m dependent dof 
% n independent dof  n= s + f
% f free dof
% s single point constraint dof
%
% Input:  u_f     	solution vectors (f size) 
%					in Matlab workspace
%		  G_mn      Reduction matrix from constraints (m x n)
%					in Matlab workspace
%		  y_s		vectors of enforced displacements y_s 
%					in Matlab workspace
%
% Output: u_g       solution vectors (g size)
%
% Input from global workspace:
%
%         uset      uset.pv_*  partitioning vectors and sizes
%					uset.*size   *=n,m etc.
%
% Called by  sol101 (ms), Normalmodes (ms), sol159 (ms) (all solution sequences)
% Calls  none 
% where ms= m-script, mf= m-function, mex= executable function (c-code)
%
% m_set and n_set index vectors are with respect to (wrt) the g- set
% s_set and f_set index vectors are with respect to (wrt) the n- set

%Merge f_set and s_set to n_set

ncol= size( u_f, 2);
u_n= sparse(uset.nsize,ncol);
u_n(uset.pv_f,:)= u_f;


% Note: we assume u_f and y_s have the same no.of columns
if ~isempty(y_s)
	u_n(uset.pv_s,:)= y_s;
end

%   Merge n_set and m_set to g_set

u_g = sparse(uset.gsize,ncol);
u_g(uset.pv_n,:)= u_n;

	
if (uset.msize>0)
	u_m = G_mn * u_n;
	u_g(uset.pv_m,:)= u_m;
end

end
