function uset=builduset( bgpdt, bgpdtb,analysis);
% BUILDUSET builduset(bgpdt, bgpdtb)
%
% Builds the uset table from the bgpdt table. 
%
% Input: 	bgpdt, bgpdtb  	pointer to bgpdt table on data base
%           analysis: analysis type, string
%
% Output: 	uset 		structure of partitioning vectors and its sizes
%						in global Matlab workspace
%
% Calls  Upartn (mex)
% where ms= m-script, mf= m-function, mex= executable function (c-code)
%
% This function is called after the uset bits in the bgpdt table have been
% determined, e.g. after Gp4 or after Gpsp.
%
% The uset table is a matlab structure containing     
%
% uset.pv_g		g-set partitioning vector
% uset.gsize 	size of the g-set
% uset.pv_n		n-set partitioning vector with respect to (wrt) the g-set
% uset.nsize 	size of the n-set
% uset.pv_m  	m-set partitioning vector wrt the g-set
% uset.msize  	size of the m-set
% uset.pv_s  	s-set partitioning vector wrt the n-set
% uset.ssize    size of the s-set
% uset.pv_f  	f-set partitioning vector wrt the n-set
% etc.
%
% The sets have the following hierarchy
%
% p - e       p = e + g    p= physical dof, e= extra point dofs
%   - g - m           g= n + m   g= grid dofs,  m= multi-point constraint dofs
%       - n - s          n= f + s   n= dofs not constr.by m, s= single-point constr.dofs
%           - f - o         f= a + o   f= free dofs, o= omitted dofs
%               - a - q        a= t + q   a= assembled dofs, q= generalized modal dofs   
%                   - t - r       t= l + r  t= total dofs, r= rigid body dofs
%                       - l - c      l= c + b + lm   l= left-over dofs, c= free dofs,
%                           - b                      b= fixed dofs for modal reduction,
%                           - lm                     lm= Lagrange multipliers.
%
% any combination of sets can be constructed, e.g.
% d= a + e    d= dynamic dofs

%			
% Go down the set hierarchy and fill the structure
% note that the order m - s - o - q - r must be kept, the m- and n-set partitioning
% vector are wrt the g-set, the s- and f-set partitioning vectors are wrt the n-set,
% etc.
%

% split g into m and n

[uset.pv_m, uset.pv_n]= Upartn( bgpdt, bgpdtb,analysis, 'g', 'm', 'n');
uset.msize= length(uset.pv_m);
uset.nsize= length(uset.pv_n);
uset.gsize= uset.msize + uset.nsize;

% split n into s and f

[uset.pv_s, uset.pv_f]= Upartn( bgpdt, bgpdtb,analysis, 'n', 's', 'f');
uset.ssize= length(uset.pv_s);
uset.fsize= length(uset.pv_f);

% split f into o and a

[uset.pv_o, uset.pv_a]= Upartn( bgpdt, bgpdtb,analysis, 'f', 'o', 'a');
uset.osize= length(uset.pv_o);
uset.asize= length(uset.pv_a);

% split a into q and t

[uset.pv_q, uset.pv_t]= Upartn( bgpdt, bgpdtb,analysis, 'a', 'q', 't');
uset.qsize= length(uset.pv_q);
uset.tsize= length(uset.pv_t);

% split t into r and l

[uset.pv_r, uset.pv_l]= Upartn( bgpdt, bgpdtb,analysis, 't', 'r', 'l');
uset.rsize= length(uset.pv_r);
uset.lsize= length(uset.pv_l);
