function [num_gauss,first_gauss_area_coord,second_gauss_area_coord,third_gauss_area_coord,gauss_weights]=GaussTria(order)
%GAUSSTRIA - get Gauss point for triangle elements
%
%   This routine computes gaussian points on a reference triangle, in terms of their area coordinates. 
%   The number of gaussian points returned depends on the order of integration ('order'). The order of 
%   integration can be computed from the polynomial degree p that needs to be integrated. The formula is: 
%   order = (p+1) /2 
%   order=1, num_gauss=1. Can integrate polynomials of degree 0 to 1
%
%   Usage:
%      [num_gauss,first_gauss_area_coord,second_gauss_area_coord,third_gauss_area_coord,gauss_weights]=GaussTria(order)

if order==1,
	num_gauss=1;
	gauss_weights=1.732050807568877;
	first_gauss_area_coord= 0.333333333333333;
	second_gauss_area_coord= 0.333333333333333;
	third_gauss_area_coord= 0.333333333333333;

%order=2, num_gauss=3. Can integrate polynomials of degree 0 to 3
elseif order==2,
	
	num_gauss=3;
	gauss_weights=[ 0.577350269189625, 0.577350269189625, 0.577350269189625];
	first_gauss_area_coord=[ 0.666666666666667, 0.166666666666667, 0.166666666666667];
	second_gauss_area_coord=[ 0.166666666666667, 0.666666666666667, 0.166666666666667];
	third_gauss_area_coord=[ 0.166666666666667, 0.166666666666667, 0.666666666666667];

%order=3, num_gauss=4. Can integrate polynomials of degree 0 to 5
elseif order==3,
	num_gauss=4;
	gauss_weights=[ -0.974278579257493, 0.902109795608790, 0.902109795608790, 0.902109795608790];
	first_gauss_area_coord=[ 0.333333333333333, 0.600000000000000, 0.200000000000000, 0.200000000000000];
	second_gauss_area_coord=[ 0.333333333333333, 0.200000000000000, 0.600000000000000, 0.200000000000000];
	third_gauss_area_coord=[ 0.333333333333333, 0.200000000000000, 0.200000000000000, 0.600000000000000];

%order=4, num_gauss=6. Can integrate polynomials of degree 0 to 7
elseif order==4,
	num_gauss=6;
	gauss_weights=[ 0.386908262797819, 0.386908262797819, 0.386908262797819, 0.190442006391807, 0.190442006391807, 0.190442006391807];
	first_gauss_area_coord=[ 0.108103018168070, 0.445948490915965, 0.445948490915965, 0.816847572980459, 0.091576213509771, 0.091576213509771];
	second_gauss_area_coord=[ 0.445948490915965, 0.108103018168070, 0.445948490915965, 0.091576213509771, 0.816847572980459, 0.091576213509771];
	third_gauss_area_coord=[ 0.445948490915965, 0.445948490915965, 0.108103018168070, 0.091576213509771, 0.091576213509771, 0.816847572980459];

%order=5, num_gauss=7. Can integrate polynomials of degree 0 to 9
elseif order==5,
	num_gauss=7;
	
	gauss_weights=[ 0.389711431702997, 0.229313399254729, 0.229313399254729, 0.229313399254729, 0.218133059367230, 0.218133059367230, 0.218133059367230];
	first_gauss_area_coord=[ 0.333333333333333, 0.059715871789770, 0.470142064105115, 0.470142064105115, 0.797426985353087, 0.101286507323456, 0.101286507323456];
	second_gauss_area_coord=[ 0.333333333333333, 0.470142064105115, 0.059715871789770, 0.470142064105115, 0.101286507323456, 0.797426985353087, 0.101286507323456];
	third_gauss_area_coord=[ 0.333333333333333, 0.470142064105115, 0.470142064105115, 0.059715871789770, 0.101286507323456, 0.101286507323456, 0.797426985353087];

%order=6, num_gauss=12. Can integrate polynomials of degree 0 to 11
elseif order==6,
	num_gauss=12;
	gauss_weights=[ 0.202279763184836, 0.202279763184836, 0.202279763184836, 0.088065961139281, 0.088065961139281, 0.088065961139281, ...
		 0.143502272432755, 0.143502272432755, 0.143502272432755, 0.143502272432755, 0.143502272432755, 0.143502272432755];
	first_gauss_area_coord=[ 0.501426509658179, 0.249286745170910, 0.249286745170910, 0.873821971016996, 0.063089014491502, 0.063089014491502,  ...
		 0.053145049844817, 0.053145049844817, 0.310352451033784, 0.636502499121399, 0.310352451033784, 0.636502499121399];
	second_gauss_area_coord=[ 0.249286745170910, 0.501426509658179, 0.249286745170910, 0.063089014491502, 0.873821971016996, 0.063089014491502,  ...
		 0.310352451033784, 0.636502499121399, 0.053145049844817, 0.053145049844817, 0.636502499121399, 0.310352451033784];
	third_gauss_area_coord=[ 0.249286745170910, 0.249286745170910, 0.501426509658179, 0.063089014491502, 0.063089014491502, 0.873821971016996,  ...
		 0.636502499121399, 0.310352451033784, 0.636502499121399, 0.310352451033784, 0.053145049844817, 0.053145049844817];
else
	error('GaussTria error message: order not supported yet');
end
