function plotanalyse(md)
%PLOTANALYSE - analyse entire model by plotting everything!
%
%   Usage:
%      plotanalyse(md)

%Do a series of plots that will help the user analyse what is going on. 
plot(md,'data','segmentonneumann_diag','title','dynamic boundary conditions',...
		'data','gridondirichlet_diag','title','fixed velocity grids',...
		'data','vx_obs','title','vx observation (m/s)',...
		'data','vy_obs','title','vy observation (m/s)',... 
		'colorbar#all','on','figure',1);

plot(md,'data','surface','title','surface','data','thickness','title','thickness',...
        'data','bed','title','bedrock','colorbar#all','on','figure',2);

plot(md,'data','drag','title','drag coefficient','data','p','title','p coeff',...
         'data','q','title','q coeff','colorbar#all','on','figure',3);

plot(md,'data','elementoniceshelf','title','elements on iceshelf',...
        'data','gridoniceshelf','title','nodes on iceshelf',...
		'data','elementonicesheet','title','elements on icesheet',...
		'data','gridonicesheet','title','nodes on icesheet','colorbar#all','on','figure',4);
