function plot_tensor_principal(md,options_structure,width,i,tensor,type,plot_options);
%PLOT_TENSOR_PRINCIPAL - plot principal values
%
%   Usage:
%      plot_tensor_principal(md,options_structure,width,i,tensor,type,plot_options);
%
%   See also: PLOTMODEL

	%Compute the indexes of the components plots
	upperplots=fix((i-1)/width);
	if upperplots==0, leftplots=i-1; else leftplots=i-width*upperplots-1; end
	if strcmpi(md.type,'2d')%3 components -> 3 indexes
		index1=4*width*upperplots+2*leftplots+1;
		index2=index1+1;
		index3=index1+width*2;
		index4=index3+1;
		newwidth=2*width;
	elseif strcmpi(md.type,'3d')%6 components -> 6 indexes
		index1=3*3*width*upperplots+3*leftplots+1;
		index2=index1+1;
		index3=index1+2;
		index4=index1+width*3;
		index5=index4+1;
		index6=index4+2;
		newwidth=3*width;
	end

	%plot principal axis
	type1=[type 'axis1'];
	plot_tensor_principalaxis(md,options_structure,newwidth,index1,tensor,type1,plot_options);
	type2=[type 'axis2'];
	plot_tensor_principalaxis(md,options_structure,newwidth,index2,tensor,type2,plot_options);
	if  strcmpi(md.type,'3d')
		type3=[type 'axis3'];
		plot_tensor_principalaxis(md,options_structure,newwidth,index3,tensor,type3,plot_options);
	end

	%smoothing?
	if strcmpi(options_structure.smooth,'yes') & length(tensor.principalvalue1)==md.numberofelements
		tensor.principalvalue1=elementstogrids(md,tensor.principalvalue1);
		tensor.principalvalue2=elementstogrids(md,tensor.principalvalue2);
		if  strcmpi(md.type,'3d'), tensor.principalvalue3=elementstogrids(md,tensor.principalvalue3); end
	end

			
	%layer projection? 
	if ~isnan(options_structure.layer) & options_structure.layer>=1,
		tensor.principalvalue1=project2d(md,tensor.principalvalue1,options_structure.layer); %project onto 2d mesh
		tensor.principalvalue2=project2d(md,tensor.principalvalue2,options_structure.layer);
		tensor.principalvalue3=project2d(md,tensor.principalvalue3,options_structure.layer);

		%we modify the mesh temporarily to a 2d mesh from which the 3d mesh was extruded. 
		md.x=md.x2d;
		md.y=md.y2d;
		md.z=md.z2d;
		md.elements=md.elements2d;
		md.elements_type=md.elements_type2d;
	end

	%units
	if ~isnan(options_structure.unitmultiplier),
		md.x=md.x*options_structure.unitmultiplier;
		md.y=md.y*options_structure.unitmultiplier;
		md.z=md.z*options_structure.unitmultiplier;
	end

	if length(tensor.principalvalue1)==length(md.elements),
		if ~isnan(options_structure.noiceshelf) & options_structure.noiceshelf,
			tensor.principalvalue1(find(md.elementoniceshelf))=NaN;
			tensor.principalvalue2(find(md.elementoniceshelf))=NaN;
			if  strcmpi(md.type,'3d')
				tensor.principalvalue3(find(md.elementoniceshelf))=NaN;
			end
		end
		if ~isnan(options_structure.noicesheet) & options_structure.noicesheet,
			tensor.principalvalue1(find(~md.elementoniceshelf))=NaN;
			tensor.principalvalue2(find(~md.elementoniceshelf))=NaN;
			if  strcmpi(md.type,'3d')
				tensor.principalvalue3(find(~md.elementoniceshelf))=NaN;
			end
		end

		if (strcmpi(md.type,'2d')),
			A=md.elements(:,1); B=md.elements(:,2); C=md.elements(:,3); 

			subplot(2*width,2*width,index3)
			patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue1,'FaceColor','flat','EdgeColor','black');
			Apply_options_tensor(options_structure,type,'principal value 1')

			subplot(2*width,2*width,index4)
			patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue2,'FaceColor','flat','EdgeColor','black');
			Apply_options_tensor(options_structure,type,'principal value 2')
		else
			if options_structure.layer>=1,
				A=md.elements(:,1); B=md.elements(:,2); C=md.elements(:,3); 

				subplot(3*width,3*width,index4)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue1,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'principal value 1')

				subplot(3*width,3*width,index5)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue2,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'principal value 2')

				subplot(3*width,3*width,index6)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue3,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'principal value 3')

			else
	
				A=md.elements(:,1); B=md.elements(:,2); C=md.elements(:,3); D=md.elements(:,4); E=md.elements(:,5); F=md.elements(:,6);

				subplot(3*width,3*width,index4)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue1,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue1,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue1,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue1,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue1,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'principal value 1')

				subplot(3*width,3*width,index5)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue2,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue2,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue2,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue2,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue2,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'principal value 2')

				subplot(3*width,3*width,index6)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue3,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue3,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue3,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue3,'FaceColor','flat','EdgeColor','black');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'CData', tensor.principalvalue3,'FaceColor','flat','EdgeColor','black');
				Apply_options_tensor(options_structure,type,'principal value 3')
			end
		end

	elseif length(tensor.principalvalue1)==md.numberofgrids |  length(tensor.principalvalue1)==md.numberofgrids2d,
		if ~isnan(options_structure.noiceshelf) & options_structure.noiceshelf,
			pos=find(md.gridoniceshelf);
			tensor.principalvalue1(pos)=NaN;
			tensor.principalvalue2(pos)=NaN;
			if strcmpi(md.type,'3d')
				tensor.principalvalue3(pos)=NaN;
			end
		end
		if ~isnan(options_structure.noiceshelf) & options_structure.noicesheet,
			pos=find(md.gridonicesheet);
			tensor.principalvalue1(pos)=NaN;
			tensor.principalvalue2(pos)=NaN;
			if strcmpi(md.type,'3d')
				tensor.principalvalue3(pos)=NaN;
			end
		end

		if strcmpi(md.type,'2d'),
			A=md.elements(:,1); B=md.elements(:,2); C=md.elements(:,3); 

			subplot(2*width,2*width,index3)
			patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData',tensor.principalvalue1 ,'FaceColor','flat','EdgeColor','none');
			Apply_options_tensor(options_structure,type,'principal value 1')

			subplot(2*width,2*width,index4)
			patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData',tensor.principalvalue2 ,'FaceColor','flat','EdgeColor','none');
			Apply_options_tensor(options_structure,type,'principal value 2')
		else
			if options_structure.layer>=1,
				A=md.elements(:,1); B=md.elements(:,2); C=md.elements(:,3); 

				subplot(3*width,3*width,index4)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData',tensor.principalvalue1 ,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'principal value 1')

				subplot(3*width,3*width,index5)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData',tensor.principalvalue2 ,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'principal value 2')

				subplot(3*width,3*width,index6)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData',tensor.principalvalue3 ,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'principal value 3')
			else
				A=md.elements(:,1); B=md.elements(:,2); C=md.elements(:,3); D=md.elements(:,4); E=md.elements(:,5); F=md.elements(:,6);

				subplot(3*width,3*width,index4)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue1,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue1,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue1,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue1,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue1,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'principal value 1')

				subplot(3*width,3*width,index5)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue2,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue2,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue2,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue2,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue2,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'principal value 2')

				subplot(3*width,3*width,index6)
				patch( 'Faces', [A B C], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue3,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [D E F], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue3,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [A B E D], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue3,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [B E F C ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue3,'FaceColor','flat','EdgeColor','none');
				patch( 'Faces', [C A D F ], 'Vertices', [md.x md.y md.z],'FaceVertexCData', tensor.principalvalue3,'FaceColor','flat','EdgeColor','none');
				Apply_options_tensor(options_structure,type,'principal value 3')
			end
		end
	end
end

function Apply_options_tensor(options_structure,type,component)
%apply options
	if isnan(options_structure.title)
		if ismember('_',type) %user plotet stress_tensor
			strings=strsplit(type,'_');
			string=strings{1};
		else %default plot: user requested stress
			string=type;
		end
		options_structure.title=[upper(string(1)) string(2:end) ' ' component];
	end
	applyoptions(md,[],options_structure);
end
