function plot_quivervel(md,options_structure,width,i);
%PLOT_QUIVERVEL - superimpose arrows and magnitude of the velocity
%
%   Usage:
%      plot_quivervel(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%process data and model
[x y z elements is2d]=processmesh(md,options_structure);
[vx isongrid]=processdata(md,md.vx,options_structure);
[vy isongrid]=processdata(md,md.vy,options_structure);
if ~isnan(md.vz)
	[vz isongrid]=processdata(md,md.vz,options_structure);
end

%edgecolor?
if ~isnan(options_structure.edgecolor),
	edgecolor=options_structure.edgecolor;
else
	edgecolor='none';
end

%plot
subplot(width,width,i); 

if is2d
	hold on
	colormap('default')
	A=elements(:,1); B=elements(:,2); C=elements(:,3); 
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', data,'FaceColor','interp','EdgeColor',edgecolor);
	colorbar;
	quiver(x,y,vx,vy,'k')
	alpha(0.7)
else
	hold on
	colormap('default')
	A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', data,'FaceColor','interp','EdgeColor',edgecolor);
	patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', data,'FaceColor','interp','EdgeColor',edgecolor);
	patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', data,'FaceColor','interp','EdgeColor',edgecolor);
	patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', data,'FaceColor','interp','EdgeColor',edgecolor);
	patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', data,'FaceColor','interp','EdgeColor',edgecolor);
	colorbar;
	quiver3(x,y,z,vx,vy,vz);
	alpha(0.7)
end

%apply options
if isnan(options_structure.title)
	options_structure.title='Velocity';
end 
if isnan(options_structure.colorbar)
	options_structure.colorbar=1;
end
applyoptions(md,[],options_structure);
