function plot_overlay(md,data,options_structure,width,i)
%PLOT_OVERLAY - superimpose radar image to a given field
%
%   Usage:
%      plot_overlay(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%2d plots only
if ~strcmpi(md.type,'2d'),
	error('plot_overlay error message: only 2d plots allowed');
end

%highres?
if ~isnan(options_structure.highres),
	highres=options_structure.highres;
else
	highres=0;
end

%alpha?
if ~isnan(options_structure.alpha),
	transparency=options_structure.alpha;
else
	transparency=1.5; %rignot setting.
end

%smoothing?
if strcmpi(options_structure.smooth,'yes') & length(data)==md.numberofelements
	smoothing=1;
else
	smoothing=0;
end

if ~isnan(options_structure.windowsize),
	windowsize=options_structure.windowsize;
else
	windowsize=1;
end

%border?
if ~isnan(options_structure.border),
	border=options_structure.border;
else
	border=0;
end

[image_rgb xm ym]=buildoverlay(md,data,transparency,highres,smoothing,windowsize,border);

%Select plot area 
subplot(width,width,i);

if ~isnan(options_structure.unitmultiplier),
	xm=xm*options_structure.unitmultiplier;
	ym=ym*options_structure.unitmultiplier;
end

%Plot: 
imagesc(xm,ym,image_rgb);set(gca,'YDir','normal');

%Apply options, without colorbar and without grid
options_structure.colorbar=0;

applyoptions(md,data,options_structure);

%colorbar
if ~isnan(options_structure.colorbar),

	%create colorbar with correct colors and position
	colorbar_rgb=buildoverlaycolorbar(md,data,transparency);
	colorbar_handle=colorbar; 
	colorbar_image_handle=get(colorbar_handle,'Children'); 
	set(colorbar_image_handle,'CData',colorbar_rgb);
	set(colorbar_handle,'Position',options_structure.colorbarpos);

	%modify ticks.
	if isfield(struct(md),data) data=eval(['md.' data ';']); end
	data(find(data<1.5))=1.5;
	
	scalestring=get(colorbar_handle,'YTickLabel');
	scalevalues=get(colorbar_handle,'YTick');
	scaleminmax=caxis;
	numvalues=length(scalevalues);

	scalestring=[];
	for i=1:numvalues,
		fraction=(scalevalues(i)-scaleminmax(1))/(scaleminmax(2)-scaleminmax(1));
		scalevalues(i)=exp(min(log(data))+(max(log(data))-min(log(data)))*fraction);

		scalestring=[scalestring; sprintf('%8.4g',scalevalues(i))];
	end
	set(colorbar_handle,'YTickLabel',scalestring);
	set(colorbar_handle,'YColor','y');
	set(colorbar_handle,'FontSize',16);
end

%take axis off
axis off;

%put axis equal
axis equal;
