function md2=model2ocmodel(md,repository)
%MODEL2OCMODEL - create an out of core model
%
%   This routine will take an input model, running in core (ie: md.repository=''),
%   and copy all its fields to an output model which will run out of core on 'repository'.
%
%   Usage:
%      md2=model2ocmodel(md,repository);
%
%   Example:
%      md2=model2ocmodel(md,'PineIsland');

md2=model(repository);

structfields=fields(md);
for i=1:length(structfields),
	field=structfields(i);field=field{1};
	if strcmpi(field,'repository'),
		%we don't want to clobber md2.repository!
		continue;
	end
	fieldval=getfield(md,field);
	if isfield(struct(md2),field),
	eval(['md2.' field '=fieldval;']);
	end
end
