function interp=domaintomesh(md,domainname,interptype)
%DOMAINTOMESH - flag elements or nodes located inside an Argus contour
%
%   from an Argus domain outline, and a @model object, figure out
%   which elements (interptype='element') or which grid (interptype='node')
%   is inside the domain.
%
%   Usage:
%      interp=domaintomesh(md,domainname,interptype)
%
%   Example:
%      flag=domaintomesh(md,'Domain.exp','node');
%
%   See also: ARGUSCONTOURTOMESH

%some checks on list of arguments
if ((nargin~=3) | (nargout~=1)),
	domaintomeshusage();
	error('domaintomesh error message');
end
if ((~ischar(domainname)) | (~ischar(interptype))  )
	domaintomeshusage();
	error('domaintomesh error message');
end

if ( (~strcmp(interptype,'node')) & (~strcmp(interptype,'element')) )
	domaintomeshusage();
	error('domaintomesh error message');
end

[rinterp]=ArgusContourToMesh(md.elements,md.x,md.y,expread(domainname,1),interptype,1);
interp=IMdb('select matrix from rinterp');
IMdb('drop rinterp');

function domaintomeshusage(),
disp('usage: md=domaintomesh(md,domainname,interptype')
