function md=addnote(md,string)
%ADDNOTE - add a note to the existing model notes field
%
%   Usage:
%      md=addnote(md,string);
%
%   Example:
%      md=addnote(md,'Pine Island, Geometry of 2007');

if (nargin~=2) | (nargout~=1),
	addnoteusage;
	error(' ');
end

if ~ischar(string),
	error('addnote error message: second input argument should be a string');
end
notes=md.notes;

if ischar(notes),
	newnotes=cell(2,1);
	newnotes(1)={notes};
	newnotes(2)={string};
else
	newnotes=cell(length(notes)+1,1);
	for i=1:length(notes),
		newnotes(i)=notes(i);
	end
	newnotes(length(notes)+1)={string};
end

md.notes=newnotes;

function addnoteusage()
disp('addnote usage:');
disp('   model=addnote(model,string)');
