function BuildQueueingScriptgemini(md,solutiontype,executionpath,codepath)
%BUILDQUEUEINGSCRIPTGEMINI - ...
%
%   Usage:
%      BuildQueueingScriptgemini(md,executionpath,codepath)

scriptname=[md.name '.queue'];

fid=fopen(scriptname,'w');
if fid==-1,
	error(['BuildQueueingScriptgeminierror message: could not open ' scriptname ' file for ascii writing']);
end

fprintf(fid,'#!/bin/sh\n');
fprintf(fid,'#BSUB -n %i -W %i\n',md.np,md.time);
fprintf(fid,'#BSUB -J %s\n',md.name);
if ~isempty(md.queue),
	fprintf(fid,'#BSUB -q %s\n',md.queue);
end
fprintf(fid,'#BSUB -o %s.outlog -e %s.errlog\n',md.name,md.name);
fprintf(fid,'cd %s\n',executionpath);
fprintf(fid,'rm -rf %s.outlog %s.errlog %s.lock\n',md.name,md.name,md.name);

if strcmpi(solutiontype,'diagnostic_horiz') |  strcmpi(solutiontype,'diagnostic'),
	fprintf(fid,'mpirun -np %i %s/diagnostic.exe %s %s.bin %s.outbin %s.lock',md.np,codepath,executionpath,md.name,md.name,md.name);
elseif strcmpi(solutiontype,'control') ,
	fprintf(fid,'mpirun -np %i %s/control.exe %s %s.bin %s.outbin %s.lock',md.np,codepath,executionpath,md.name,md.name,md.name);
elseif strcmpi(solutiontype,'thermalsteady') ,
	fprintf(fid,'mpirun -np %i %s/thermalsteady.exe %s %s.bin %s.outbin %s.lock',md.np,codepath,executionpath,md.name,md.name,md.name);
else
	error('BuildQueueingScriptgemini error message: unsupported solution type!');
end
fclose(fid);
