function epsilon=GetStrainRate(triaelem,vxvy_list,xyz_list,gauss_l1l2l3)
%GETSTRAINRATE - return the strain rate of a pentaelem
%
%   This function return the strain rate needed for Glen's flow law for the element pentaelem
%   The strain rate epsilon is calculated thanks to the formula epsilon=B*U
%   Where epsilon=[exx eyy exy] and U=[u1;v1;..;u3;v3]
%   The matrix B is the same as in K=tBDBprime
%
%   Usage:
%      epsilon=GetStrainRate(pentaelem,vxvy_list,xyz_list,gauss_coord)
%
%   See also GETB

B=GetB(triaelem,xyz_list,gauss_l1l2l3);

vxvy_list_transp=vxvy_list';
U=[vxvy_list_transp(1:2,1);vxvy_list_transp(1:2,2);vxvy_list_transp(1:2,3)];

epsilon=B*U;
