function Bprime=GetBprime(triaelem,xyz_list,gauss_l1l2l3)
%GETBPRIME - compute the Bprime matrix for a diagnostic solution
%
%   Compute B'  matrix. B'=[B1' B2' B3'] where Bi' is of size 3*NDOF2. 
%   For grid i, Bi' can be expressed in the basic coordinate system by:
%   Bi_basic'=[ 2*dh/dx    dh/dy ]
%             [   dh/dx   2*dh/dy]
%             [   dh/dy   dh/dx  ]
%   where h is the interpolation function for grid i.
%
%   Usage:
%      Bprime=GetBprime(triaelem,xyz_list,gauss_l1l2l3)
% 
%   See also GETB, CREATEKMATRIX

	num_grids=3;	
	NDOF2=2;

	dh1dh2dh3_basic=GetNodalFunctionsDerivativesBasic(triaelem,xyz_list,gauss_l1l2l3);

	%Build Bprime:
	Bprime=zeros(3,NDOF2*num_grids);
	for i=1:num_grids,
		Bprime(1,NDOF2*(i-1)+1)=2*dh1dh2dh3_basic(1,i);
		Bprime(1,NDOF2*(i-1)+2)=  dh1dh2dh3_basic(2,i);
		Bprime(2,NDOF2*(i-1)+1)=  dh1dh2dh3_basic(1,i);
		Bprime(2,NDOF2*(i-1)+2)=2*dh1dh2dh3_basic(2,i);
		Bprime(3,NDOF2*(i-1)+1)=dh1dh2dh3_basic(2,i);
		Bprime(3,NDOF2*(i-1)+2)=dh1dh2dh3_basic(1,i);
	end
