function J=GetJacobian(tetraelem,xyz_list,gauss_coord)
%GETJACOBIAN- computes the jacobian for a tetraelem
%
%   Usage:
%      J=GetJacobian(tetraelem,z_list,gauss_coord)
%
%   See also GETJACOBIANDETERMINANT

%The Jacobian is constant over the element, discard the gaussian points. 

J=zeros(3,3);
sqrt3=sqrt(3.0);
sqrt6=sqrt(6);

%grids coordinates	
x1=xyz_list(1,1);
y1=xyz_list(1,2);
z1=xyz_list(1,3);

x2=xyz_list(2,1);
y2=xyz_list(2,2);
z2=xyz_list(2,3);

x3=xyz_list(3,1);
y3=xyz_list(3,2);
z3=xyz_list(3,3);

x4=xyz_list(4,1);
y4=xyz_list(4,2);
z4=xyz_list(4,3);

%Computation of the jacobian on this gauss point
J(1,1)=1.0/2.0* (-x1+x2);
J(2,1)=1.0/2.0* (-y1+y2);
J(3,1)=1.0/2.0* (-z1+z2);

J(1,2)=1.0/(2*sqrt3)* (-x1+x2+2*x3);
J(2,2)=1.0/(2*sqrt3)* (-y1+y2+2*y3);
J(3,2)=1.0/(2*sqrt3)* (-z1+z2+2*z3);

J(1,3)=1.0/(2*sqrt6)* (-x1-x2-x3+x4);
J(2,3)=1.0/(2*sqrt6)* (-y1-y2-y3+y4);
J(3,3)=1.0/(2*sqrt6)* (-z1-z2-z3+z4);
