function singelem = singelem(varargin)
%SINGELEM - contructor for singelem objects
%
%   Usage:
%      singelem = singelem(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	singelem.type='singelem';
	singelem.id=NaN;
	singelem.matid=NaN;
	singelem.g=zeros(2,1);
	singelem.h=zeros(2,1);
	singelem.k=zeros(2,1);
	singelem=class(singelem,'singelem');
				
case 1
	%If single argument of class singelem, we have a copy constructor. 
	if (isa(varargin{1},'singelem'))
		singelem = varargin{1};
	else
		error('singelem constructor error message: copy constructor called on a non ''singelem'' class object');
	end 
otherwise
	error('singelem constructor error message: 0 of 1 argument only in input.');
end
