%
%  display for the response_function class.
%
%  []=display(rf)
%
function []=display(rf)

if ~isa(rf,'response_function')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(rf),'response_function');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(rf)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(rf),inputname(1),string_dim(rf,i)));
    disp(sprintf('    descriptor: ''%s'''  ,rf(i).descriptor));
    disp(sprintf('         respl: %s'      ,string_vec(rf(i).respl)));
    disp(sprintf('         probl: %s'      ,string_vec(rf(i).probl)));
    disp(sprintf('          rell: %s'      ,string_vec(rf(i).rell)));
    disp(sprintf('         grell: %s\n'    ,string_vec(rf(i).grell)));
end

end
