function epsilon=GetStrainRate(pentaelem,vxvy_list,xyz_list,gauss_coord)
%GETSTRAINRATE - return the strain rate of a pentaelem
%
%   This function return the strain rate needed for Glen's flow law for the element pentaelem
%   The strain rate epsilon is calculated thanks to the formula epsilon=B*U
%   Where epsilon=[exx eyy exy exz eyz] and U=[u1;v1;..;u6;v6]
%   The matrix B is the same as in K=tBDBprime
%
%   Usage:
%      epsilon=GetStrainRate(pentaelem,vxvy_list,xyz_list,gauss_coord)
%
%   See also GETSTRAINRATESTOKES, GETB_HORIZ

B=GetB_horiz(pentaelem,xyz_list,gauss_coord);
vxvy_list_transp=vxvy_list';
U=[vxvy_list_transp(1:2,1);vxvy_list_transp(1:2,2);vxvy_list_transp(1:2,3);vxvy_list_transp(1:2,4);vxvy_list_transp(1:2,5);vxvy_list_transp(1:2,6)];

epsilon=B*U;
