function Bprime=GetBprimeStokes(pentaelem,xyz_list,gauss_coord)
%GETBPRIMESTOKES - computes the Bprime matrix for Stokes' diagnostic
%
%   Compute B'  matrix. B'=[B1' B2' B3' B4' B5' B6' Bb'] where Bi' is of size 3*NDOF2. 
%   For grid i, Bi' can be expressed in the basic coordinate system by:
%   Bi_basic'=[ dh/dx   0          0       0]
%             [   0      dh/dy      0       0]
%             [   0      0         dh/dz    0]
%             [  dh/dy   dh/dx      0       0]
%             [  dh/dz   0        dh/dx     0]
%             [   0      dh/dz    dh/dy     0]
%             [  dh/dx   dh/dy    dh/dz     0]
%             [   0      0          0       h]
%   where h is the interpolation function for grid i.
%
%   Same thing for the bubble fonction except that there is no fourth column
%
%   Usage:
%      Bprime=GetBprimeStokes(pentaelem,xyz_list,gauss_coord)
%
%   See also GETBSTOKES, CREATEKMATRIX

	num_grids=6;%bubble function not included	
	NDOF4=4;

	l1l6=GetNodalFunctions(pentaelem,gauss_coord);
	dh1dh7_basic=GetNodalFunctionsDerivativesBasicStokes(pentaelem,xyz_list,gauss_coord);

	%Build Bprime:
	Bprime=zeros(8,NDOF4*num_grids+3);
	for i=1:num_grids+1,
		Bprime(1,NDOF4*(i-1)+1)=dh1dh7_basic(1,i);
		Bprime(1,NDOF4*(i-1)+2)=0;
		Bprime(1,NDOF4*(i-1)+3)=0;

		Bprime(2,NDOF4*(i-1)+1)=0;
		Bprime(2,NDOF4*(i-1)+2)=dh1dh7_basic(2,i);
		Bprime(2,NDOF4*(i-1)+3)=0;

		Bprime(3,NDOF4*(i-1)+1)=0;
		Bprime(3,NDOF4*(i-1)+2)=0;
		Bprime(3,NDOF4*(i-1)+3)=dh1dh7_basic(3,i);

		Bprime(4,NDOF4*(i-1)+1)=dh1dh7_basic(2,i);
		Bprime(4,NDOF4*(i-1)+2)=dh1dh7_basic(1,i);		
		Bprime(4,NDOF4*(i-1)+3)=0;

		Bprime(5,NDOF4*(i-1)+1)=dh1dh7_basic(3,i);
		Bprime(5,NDOF4*(i-1)+2)=0;
		Bprime(5,NDOF4*(i-1)+3)=dh1dh7_basic(1,i);

		Bprime(6,NDOF4*(i-1)+1)=0;
		Bprime(6,NDOF4*(i-1)+2)=dh1dh7_basic(3,i);
		Bprime(6,NDOF4*(i-1)+3)=dh1dh7_basic(2,i);

		Bprime(7,NDOF4*(i-1)+1)=dh1dh7_basic(1,i);
		Bprime(7,NDOF4*(i-1)+2)=dh1dh7_basic(2,i);
		Bprime(7,NDOF4*(i-1)+3)=dh1dh7_basic(3,i);

		Bprime(8,NDOF4*(i-1)+1)=0;
		Bprime(8,NDOF4*(i-1)+2)=0;
		Bprime(8,NDOF4*(i-1)+3)=0;
	end

	%Added the column for pressure
	for i=1:num_grids,
		Bprime(8,NDOF4*(i-1)+4)=l1l6(i);

	end
