function B=GetB_vert(pentaelem,xyz_list,gauss_coord)
%GETB_VERT - compute the B matrix for vertical velocity of diagnostic
%
%   Compute B  matrix. B=[dh1/dz dh2/dz dh3/dz dh4/dz dh5/dz dh6/dz];
%   where hi is the interpolation function for grid i.
%
%   Usage:
%      B=GetB_vert(pentaelem,xyz_list,gauss_coord)
%
%   See also GETBPRIME_VERT, CREATEKMATRIX 

	dh1dh6_basic=GetNodalFunctionsDerivativesBasic(pentaelem,xyz_list,gauss_coord);
	%Build B:
	B=zeros(1,6);
	for i=1:6,
		B(1,i)=dh1dh6_basic(3,i);
	end
