%
%  display for the objective_function class.
%
%  []=display(of)
%
function []=display(of)

if ~isa(of,'objective_function')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(of),'objective_function');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(of)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(of),inputname(1),string_dim(of,i)));
    disp(sprintf('    descriptor: ''%s'''  ,of(i).descriptor));
    disp(sprintf('    scale_type: ''%s'''  ,of(i).scale_type));
    disp(sprintf('         scale: %g'      ,of(i).scale));
    disp(sprintf('        weight: %g\n'    ,of(i).weight));
end

end
