%
%  definition for the normal_uncertain class.
%
%  [nuv]=normal_uncertain(varargin)
%
classdef normal_uncertain
    properties
        descriptor='';
        mean      = NaN;
        stddev    = NaN;
        lower     = NaN;
        upper     = NaN;
    end
    
    methods
        function [nuv]=normal_uncertain(varargin)

            switch nargin

%  create a default object

                case 0

%  copy the object

                case 1
                    if isa(varargin{1},'normal_uncertain')
                        nuv=varargin{1};
                    else
                        error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
                            inputname(1),class(varargin{1}),'normal_uncertain');
                    end

%  not enough arguments

                case 2
                    error('Construction of ''%s'' class object requires at least %d inputs.',...
                        'normal_uncertain',3)

%  create the object from the input

                otherwise
                    nuv.descriptor=varargin{1};
                    nuv.mean      =varargin{2};
                    nuv.stddev    =varargin{3};
                    if (nargin >= 4)
                        nuv.lower     =varargin{4};
                        if (nargin >= 5)
                            nuv.upper     =varargin{5};
                            if (nargin > 5)
                                warning('normal_uncertain:extra_arg',...
                                    'Extra arguments for object of class ''%s''.',...
                                    class(nuv));
                            end
                        end
                    end
            end

        end
        function [desc]  =dvar_desc(nuv)
            desc=cell(size(nuv));
            for i=1:numel(nuv)
                desc(i)=cellstr(nuv(i).descriptor);
            end
            desc=allempty(desc);
        end
        function [initpt]=dvar_initpt(nuv)
            initpt=[];
        end
        function [lower] =dvar_lower(nuv)
            lower=zeros(size(nuv));
            for i=1:numel(nuv)
                lower(i)=nuv(i).lower;
            end
            lower=allnan(lower);
        end
        function [upper] =dvar_upper(nuv)
            upper=zeros(size(nuv));
            for i=1:numel(nuv)
                upper(i)=nuv(i).upper;
            end
            upper=allnan(upper);
        end
        function [mean]  =dvar_mean(nuv)
            mean=zeros(size(nuv));
            for i=1:numel(nuv)
                mean(i)=nuv(i).mean;
            end
        end
        function [stddev]=dvar_stddev(nuv)
            stddev=zeros(size(nuv));
            for i=1:numel(nuv)
                stddev(i)=nuv(i).stddev;
            end
        end
        function [initst]=dvar_initst(nuv)
            initst=[];
        end
    end
end
