function md=structtomodel(md,structmd)
%STRUCTTIMODEL - convert a structure into a model. 
%
%   This function will take all the fields in structmd and copy them to corresponding
%   fields in the md @model class instance. If the field does not exist in md, it is dropped.
%
%   Usage:
%      md=structtomodel(md,structmd)

structfields=fields(structmd);
for i=1:length(structfields),
	field=structfields(i);field=field{1};
	fieldval=getfield(structmd,field);
	if isfield(struct(md),field),
		md=setfield(md,field,fieldval);
	end
end
