function md=activaterepository(md)
%ACTIVATEREPOSITORY - save the model fields separately
%
%   This function is required when a matlab session 
%   is running low on memory, or when a model is very large. 
%   By activating a repository (for example, 'repository.model'), 
%   the model fields will each separately be saved and accessed when 
%   needed. This will limit the memory use at the maximum; 
%
%   Usage:
%      md=activaterepository(md)


%for each field of the model, we create an equivalent variable, with the same name, which we 
%save in the repository. 

modelfields=fields(md);

%then save each of the big fields in their respective files
for i=1:length(modelfields),
	field=char(modelfields(i));
	eval([field '=md.' field ';']);

	%anything NaN, will be saved 

	if isnumeric(eval(field)),
		if isnan(eval(field)),
			if exist(['.' md.repository '.' field],'file');
				error(['Repository ' md.repository ' already exists! Delete all files starting with .' md.repository ' in your directory, before activating a new repository']);
			end
			eval(['save .' md.repository '.' field ' ' field]);
		end
	end
end
