function matice = matice(varargin)
%MATICE - constructor for matice object
%
%   Usage:
%      matice = matice(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	matice.id=NaN;
	matice.B=NaN;
	matice.n=NaN;
	matice=class(matice,'matice');
				
case 1
	%If single argument of class matice, we have a copy constructor. 
	if (isa(varargin{1},'matice'))
		matice = varargin{1};
	else
		error('matice constructor error message: copy constructor called on a non ''matice'' class object');
	end 
otherwise
	error('matice constructor error message: 0 of 1 argument only in input.');
end
