function Ke=CreateKMatrix(beamelem,grids,materials,inputs,analysis_type)
%CREATEKMATRIX - create the stiffmess matrix for beamelem
%
%   this stiffness matrix works for Hutter's model
%
%   Usage:
%      Ke=CreateKMatrix(beamelem,grids,materials,inputs,analysis_type)
%
%   See also CREATEPVECTOR

	if strcmpi(analysis_type,'diagnostic_hutter'),

		Ke=CreateKMatrixHutter(beamelem,grids,materials,inputs);

	else
		error('CreateKMatrix/beam error message: analysis type not supported yet')
	end
end %end function

function Ke=CreateKMatrixHutter(beamelem,grids,materials,inputs)

	%some variables
	numgrids=2;
	DOFPERGRID=2;
	numdof=numgrids*DOFPERGRID; %number of dof for element beamelem.

	%Create elementary stiffness matrix 
	Ke=elemmatrix(numdof);

	%Build linear indices for elementary stiffness matrix.
	for i=1:numgrids,
		doflist=grids(beamelem.g(i)).grid.doflist; %list of dofs in the g-set
		for j=1:DOFPERGRID,
			dof=doflist(j);
			Ke.row_indices((i-1)*DOFPERGRID+j)=dof;
		end
		
		dof=doflist(1);
	end


	if (beamelem.onbed==1),
		Ke.terms=[ 1  0  0  0
	               0  1  0  0
				  -1  0  1  0
				  0  -1  0  1];
	else
		Ke.terms=[ 0  0  0  0
	               0  0  0  0
				  -1  0  1  0
				  0  -1  0  1];
	end
end %end function
