/*!\file NewVecFromLocalSize.cpp
 * \brief: create distributed Petsc vector, using an already existing distribution
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*Petsc includes: */
#include "petscmat.h"
#include "petscvec.h"
#include "petscksp.h"

#include "./petscpatches.h"

Vec NewVecFromLocalSize(int local_size){

	int ierr;

	/*output: */
	Vec vector=NULL;

	/*determine local size of vector: */
	VecCreate(PETSC_COMM_WORLD,&vector); 
	
	VecSetSizes(vector,local_size,PETSC_DECIDE); 
	VecSetFromOptions(vector); 

	/*fill with 0: */
	VecSet(vector,0.0);

	return vector;
}




