/*!\file NewVec.cpp
 * \brief: create distributed Petsc vector.
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*Petsc includes: */
#include "petscmat.h"
#include "petscvec.h"
#include "petscksp.h"

#include "./petscpatches.h"

Vec NewVec(int size){

	int ierr;
	int local_size;

	/*output: */
	Vec vector=NULL;

	/*determine local size of vector: */
	local_size=PetscDetermineLocalSize(size);
	VecCreate(PETSC_COMM_WORLD,&vector); 
	
	VecSetSizes(vector,local_size,PETSC_DECIDE); 
	VecSetFromOptions(vector); 

	/*fill with 0: */
	VecSet(vector,0.0);

	return vector;
}




