/*!\file: mxGetAssignedField.c: 
 * \brief: abstract interface on parallel side for i/o, so it ressembles the serial i/o.
 *
 * In serial mode, this routine takes care of returning the field coming 
 * from the model. If largesize is 1, we are running out of core models in 
 * matlab, and we need to call the subsref private method from the model object
 * in order to correctly load the data from disk.
 */


#ifdef _SERIAL_

#include "mex.h"

mxArray* mxGetAssignedField(const mxArray* pmxa_array,int number, char* field){

	//output
	mxArray* mxfield=NULL;
	
	//input
	mxArray*   inputs[2];
	mxArray*  pindex=NULL;
	const	char*	fnames[2];
	mwSize		ndim=2;
	mwSize		onebyone[2] = {1,1};

	//We want to call the subsasgn method, and get the returned array.This ensures that if we are running 
	//large sized problems, the data is truly loaded from disk by the model subsasgn class method.
	inputs[0]=(mxArray*)pmxa_array; //this is the model

	//create index structure used in the assignment (index.type='.' and index.subs='x' for field x for ex)
	fnames[0] = "type";
	fnames[1] = "subs";
	pindex=mxCreateStructArray( ndim,onebyone,2,fnames);
	mxSetField( pindex, 0, "type",mxCreateString("."));
	mxSetField( pindex, 0, "subs",mxCreateString(field));
	inputs[1]=pindex;

	mexCallMATLAB( 1, &mxfield, 2, (mxArray**)inputs, "subsref");

	return mxfield;
}
#endif
