/*
 * IsInPolySerial.c:
 */

#include <math.h>
#include "./exp.h"


int IsInPolySerial(double* in,double* xc,double* yc,int numgrids,double* x,double* y,int nods, int edgevalue){

	int i,j;
	double x0,y0;

	/*Go through all grids of the mesh:*/
	for (i=0;i<nods;i++){
		if (in[i]){
			/*this grid already is inside one of the contours, continue*/
			continue;
		}
		/*pick up grid: */
		x0=x[i];
		y0=y[i];
		if (pnpoly(numgrids,xc,yc,x0,y0,edgevalue)){
			in[i]=1;
		}
		else{
			in[i]=0;
		}
	}
}
