/*!\file Spc.c
 * \brief: implementation of the Spc object
 */


#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../DataSet/DataSet.h"
#include "./objects.h"

		
Spc::Spc(){
	return;
}
Spc::Spc(int spc_sid,int spc_nodeid, int spc_dof,double spc_value){

	sid=spc_sid;
	nodeid=spc_nodeid;
	dof=spc_dof;
	value=spc_value;

	return;
}

Spc::~Spc(){
	return;
}
		
void Spc::Echo(void){

	printf("Spc:\n");
	printf("   sid: %i\n",sid);
	printf("   nodeid: %i\n",nodeid);
	printf("   dof: %i\n",dof);
	printf("   value: %g\n",value);
	return;
}
		
void  Spc::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of Spc: */
	enum_type=SpcEnum();
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall Spc data: */
	memcpy(marshalled_dataset,&sid,sizeof(sid));marshalled_dataset+=sizeof(sid);
	memcpy(marshalled_dataset,&nodeid,sizeof(nodeid));marshalled_dataset+=sizeof(nodeid);
	memcpy(marshalled_dataset,&dof,sizeof(dof));marshalled_dataset+=sizeof(dof);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);

	*pmarshalled_dataset=marshalled_dataset;
	return;
}
		
int   Spc::MarshallSize(){

	return sizeof(sid)+sizeof(nodeid)+sizeof(dof)+sizeof(value)+sizeof(int); //sizeof(int) for enum type
}

char* Spc::GetName(void){
	return "spc";
}
		

void  Spc::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/

	memcpy(&sid,marshalled_dataset,sizeof(sid));marshalled_dataset+=sizeof(sid);
	memcpy(&nodeid,marshalled_dataset,sizeof(nodeid));marshalled_dataset+=sizeof(nodeid);
	memcpy(&dof,marshalled_dataset,sizeof(dof));marshalled_dataset+=sizeof(dof);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
int Spc::Enum(void){

	return SpcEnum();

}
int    Spc::GetId(void){ return sid; }

int    Spc::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
void  Spc::DistributeNumDofs(int* numdofspernode,int analysis_type){return;}
		
int   Spc::GetNodeId(){
	
	return nodeid;
}

int Spc::GetDof(){
	return dof;
}

double Spc::GetValue(){
	return value;
}

Object* Spc::copy() {
	return new Spc(*this); 
}

