/*!\file:  Load.h
 * \brief abstract class for Load object
 * This class is a place holder for the Icefront  and the Penpair loads.
 * It is derived from Load, so DataSets can contain them.
 */ 


#ifndef _LOAD_H_
#define _LOAD_H_

#include "./Object.h"
#include "./ParameterInputs.h"
#include "../toolkits/toolkits.h"

class Load: public Object{

	public: 
		virtual       ~Load(){};
		virtual void  Echo()=0;
		virtual int   GetId()=0;
		virtual int   MyRank()=0;
		virtual void  Marshall(char** pmarshalled_dataset)=0;
		virtual int   MarshallSize()=0;
		virtual char* GetName()=0;
		virtual void  Demarshall(char** pmarshalled_dataset)=0;
		virtual void  Configure(void* elements,void* nodes,void* materials)=0;
		virtual void  CreateKMatrix(Mat Kgg,ParameterInputs* inputs,int analysis_type)=0;
		virtual void  CreatePVector(Vec pg, ParameterInputs* inputs, int analysis_type)=0;
		virtual void  UpdateFromInputs(ParameterInputs* inputs)=0;
		virtual void  PenaltyCreateKMatrix(Mat Kgg,ParameterInputs* inputs,double kmax,int analysis_type)=0;
		virtual void  PenaltyCreatePVector(Vec pg,ParameterInputs* inputs,double kmax,int analysis_type)=0;

		int           Enum();

};
#endif
