/*\file FetchData.cpp:
 * \brief: general I/O interface to fetch data.
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./io.h"

#ifdef _SERIAL_

#include <mex.h>
void FetchData(void** pdata,int* pM,int* pN,const mxArray* pdataref,char* data_type,char* sub_data_type){
	
	SerialFetchData(pdata,pM,pN,pdataref,data_type,sub_data_type);

}
#endif

#if defined(_PARALLEL_) && defined(_HAVE_PETSC_)
void FetchData(void** pdata,int* pM,int* pN,FILE* fid,char* data_type,char* sub_data_type){

	ParallelFetchData(pdata,pM,pN,fid, data_type,sub_data_type);

}
#endif
